<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://hypodash.com
 * @since      1.0.0
 *
 * @package    Hypodash
 * @subpackage Hypodash/admin/partials
 */
?>

<div class="wrap">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<form method="post" action="options.php">
		<?php
		settings_fields( 'hypodash_settings' );
		do_settings_sections( 'hypodash' );
		submit_button();
		?>
	</form>

	<h2><?php esc_html_e( 'Webhook Endpoint', 'hypodash' ); ?></h2>
	<p>
		<?php esc_html_e( 'Send Hypodash webhooks to the following URL:', 'hypodash' ); ?><br /><br />
		<code><?php echo esc_url( $webhook_url ); ?></code>
	</p>
	<?php if ( ! $webhook_on ) : ?>
		<div class="notice notice-warning inline"><p><strong><?php esc_html_e( 'Webhook is currently disabled. Enable it above to start receiving posts.', 'hypodash' ); ?></strong></p></div>
	<?php else : ?>
		<div class="notice notice-success inline"><p><strong><?php esc_html_e( 'Webhook enabled and ready to receive posts.', 'hypodash' ); ?></strong></p></div>
	<?php endif; ?>
</div>
