<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://hypodash.com
 * @since             1.0.0
 * @package           Hypodash
 *
 * @wordpress-plugin
 * Plugin Name:       Hypodash
 * Plugin URI:        https://hypodash.com
 * Description:       Automatically schedule and create AI-generated blog posts with images and YouTube videos using your own OpenAI api keys.
 * Version:           1.0.0
 * Author:            Hypodash
 * Author URI:        https://hypodash.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       hypodash
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (! defined('WPINC')) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define('HYPODASH_VERSION', '1.0.0');

// Option and API identifiers used throughout the plugin.
define('HYPODASH_OPTION_API_KEY', 'hypodash_api_key');
define('HYPODASH_OPTION_WEBHOOK_ENABLED', 'hypodash_enable_webhook');
define('HYPODASH_OPTION_WEBHOOK_SECRET', 'hypodash_webhook_secret');
define('HYPODASH_WEBHOOK_NAMESPACE', 'hypodash/v1');
define('HYPODASH_WEBHOOK_ROUTE', '/receive');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-hypodash-activator.php
 */
function hypodash_activate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-hypodash-activator.php';
	Hypodash_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-hypodash-deactivator.php
 */
function hypodash_deactivate()
{
	require_once plugin_dir_path(__FILE__) . 'includes/class-hypodash-deactivator.php';
	Hypodash_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'hypodash_activate');
register_deactivation_hook(__FILE__, 'hypodash_deactivate');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-hypodash.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function hypodash_run()
{

	$plugin = new Hypodash();
	$plugin->run();
}
hypodash_run();
